package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.Centroj73;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Centroj73DaoImpl generated by UDA, 25-abr-2016 19:06:26.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class Centroj73DaoImpl implements Centroj73Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Centroj73> rwMap = new RowMapper<Centroj73>() {
		public Centroj73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Centroj73 centroj73Ret = new Centroj73(
					resultSet.getInt("CODEMP001"), resultSet.getInt("CCEN001"),
					resultSet.getInt("NCEN001"), resultSet.getInt("PROVC001"),
					UtilDAO.hasColumn(resultSet, "PROVINCIA")
							? resultSet.getString("PROVINCIA") : "",
					resultSet.getString("RSOC001"),
					resultSet.getString("RSOS001"),
					resultSet.getString("MUNIC001"),
					resultSet.getString("DOMIC001"),
					resultSet.getString("CPOSC001"),
					resultSet.getString("LOCAL001"),
					resultSet.getString("CCIF001"));

			if (UtilDAO.hasColumn(resultSet, "CODMUNIC")) {
				centroj73Ret.setCodMunic001(resultSet.getInt("CODMUNIC"));
			}

			return centroj73Ret;
		}
	};

	// private RowMapper<Centroj73> rwMap2 = new RowMapper<Centroj73>() {
	// public Centroj73 mapRow(ResultSet resultSet, int rowNum)
	// throws SQLException {
	// Centroj73 centroj73Ret = new Centroj73();
	//
	// centroj73Ret.setCodemp001(resultSet.getInt("CODEMP001"));
	// centroj73Ret.setCcen001(resultSet.getInt("CCEN001"));
	// centroj73Ret.setNcen001(resultSet.getInt("NCEN001"));
	// centroj73Ret.setProvc001(resultSet.getInt("PROVC001"));
	// Provincia provincia = new Provincia();
	// provincia.setDescripcion(UtilDAO.hasColumn(resultSet, "PROVINCIA") ?
	// resultSet.getString("PROVINCIA") : "");
	// centroj73Ret.setProvincia(provincia);
	// centroj73Ret.setRsoc001(resultSet.getString("RSOC001"));
	// centroj73Ret.setRsos001(resultSet.getString("RSOS001"));
	// centroj73Ret.setMunic001(resultSet.getString("MUNIC001"));
	// centroj73Ret.setDomic001(resultSet.getString("DOMIC001"));
	// centroj73Ret.setCposc001(resultSet.getString("CPOSC001"));
	// centroj73Ret.setLocal001(resultSet.getString("LOCAL001"));
	// centroj73Ret.setCcif001(resultSet.getString("CCIF001"));
	// centroj73Ret.setTlf001(resultSet.getString("TLF001"));
	// centroj73Ret.setFax001(resultSet.getString("FAX001"));
	// centroj73Ret.setCnae001(resultSet.getString("CNAE001"));
	//
	// if (UtilDAO.hasColumn(resultSet, "CODMUNIC")) {
	// centroj73Ret.setCodMunic001(resultSet.getInt("CODMUNIC"));
	// }
	//
	// return centroj73Ret;
	// }
	// };

	private RowMapper<Centroj73> rwMapConsulta = new RowMapper<Centroj73>() {
		public Centroj73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			StringBuffer buff = new StringBuffer(
					Centroj73DaoImpl.STRING_BUILDER_INIT);
			Centroj73 centroj73Ret = new Centroj73();
			centroj73Ret.setTcif001(resultSet.getString("TCIF001"));
			centroj73Ret.setCcif001(resultSet.getString("CCIF001"));
			centroj73Ret.setRsoc001(resultSet.getString("RSOC001"));
			centroj73Ret.setRsos001(resultSet.getString("RSOS001"));
			centroj73Ret.setDomic001(resultSet.getString("DOMIC_001"));
			centroj73Ret.setCposc001(resultSet.getString("CPOSC001"));
			centroj73Ret.setProvc001(resultSet.getInt("PROVC001"));

			Provincia provincia = new Provincia();
			provincia.setDescripcion(UtilDAO.hasColumn(resultSet, "PROVINCIA")
					? resultSet.getString("PROVINCIA") : "");
			centroj73Ret.setProvincia(provincia);

			String muni001 = resultSet.getString("MUNIC001");
			buff.append(muni001);
			if (muni001 != null && muni001.length() < ConstantesNum.NUM_3) {
				while (buff.length() < ConstantesNum.NUM_3) {
					buff.insert(0, "0");
				}
			}
			centroj73Ret.setCodMunic001Str(buff.toString());
			centroj73Ret.setCodMunic001(resultSet.getInt("MUNIC001"));
			centroj73Ret.setMunic001(resultSet.getString("MUNICIPIO"));
			centroj73Ret.setLocal001(resultSet.getString("LOCAL001"));
			centroj73Ret.setTlf001(resultSet.getString("TLF001"));
			centroj73Ret.setFax001(resultSet.getString("FAX001"));
			centroj73Ret.setEmail001(resultSet.getString("EMAIL001"));
			centroj73Ret.setComer001(resultSet.getString("COMER001"));
			centroj73Ret.setDomif001(resultSet.getString("DOMIF001"));
			centroj73Ret.setCodprof001(resultSet.getInt("PROVF001"));

			String fmuni001 = resultSet.getString("MUNIF001");
			buff = new StringBuffer(Centroj73DaoImpl.STRING_BUILDER_INIT);
			buff.append(fmuni001);
			if (fmuni001 != null && fmuni001.length() < ConstantesNum.NUM_3) {
				while (buff.length() < ConstantesNum.NUM_3) {
					buff.insert(0, "0");
				}
			}

			centroj73Ret.setCodmunif001(resultSet.getInt("MUNIF001"));
			centroj73Ret.setCodmunif001Str(buff.toString());
			centroj73Ret.setCposf001(resultSet.getString("CPOSF001"));
			centroj73Ret.setCnae001(resultSet.getString("CNAE001"));
			centroj73Ret.setDivi001(resultSet.getString("DIVI001"));
			centroj73Ret.setGrupo001(resultSet.getString("GRUP001"));
			centroj73Ret.setClas001(resultSet.getString("CLAS001"));
			centroj73Ret.setSecc001(resultSet.getString("SECC001"));
			centroj73Ret.setRegi001(resultSet.getString("REGI001"));
			centroj73Ret.setNtra001(resultSet.getInt("NTRA001"));
			centroj73Ret.setBaja001(resultSet.getString("BAJA001"));
			centroj73Ret.setFbaja001(resultSet.getDate("FBAJA001"));
			centroj73Ret.setFactu001(resultSet.getDate("FACTU001"));
			centroj73Ret.setObser001(resultSet.getString("OBSER001"));
			centroj73Ret.setUsua001(resultSet.getString("USUA001"));
			centroj73Ret.setUsualta001(resultSet.getString("USUALTA001"));
			centroj73Ret
					.setIndtipocentro001(resultSet.getInt("INDTIPOCENTRO001"));
			centroj73Ret.setCodemp001(resultSet.getInt("CODEMP001"));
			centroj73Ret.setCnae007(resultSet.getString("CNAE007"));
			centroj73Ret.setRsoc007(resultSet.getString("RSOC007"));

			if (UtilDAO.hasColumn(resultSet, "CCEN001")) {
				centroj73Ret.setCcen001(resultSet.getInt("CCEN001"));
			}
			if (UtilDAO.hasColumn(resultSet, "NCEN001")) {
				centroj73Ret.setNcen001(resultSet.getInt("NCEN001"));
			}

			if (UtilDAO.hasColumn(resultSet, "CODMUNIC")) {
				centroj73Ret.setCodMunic001(resultSet.getInt("CODMUNIC"));
			}

			if (UtilDAO.hasColumn(resultSet, "NTRAH001")) {
				centroj73Ret.setNtrah001(resultSet.getInt("NTRAH001"));
			}
			if (UtilDAO.hasColumn(resultSet, "NTRAM001")) {
				centroj73Ret.setNtram001(resultSet.getInt("NTRAM001"));
			}

			return centroj73Ret;
		}
	};

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Centroj73> rwMapInfo = new RowMapper<Centroj73>() {
		public Centroj73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Centroj73 centro = new Centroj73(resultSet.getInt("CODEMP001"),
					resultSet.getInt("CCEN001"), resultSet.getInt("NCEN001"),
					resultSet.getInt("PROVC001"),
					resultSet.getString("PROVINCIA"),
					resultSet.getString("RSOC001"),
					resultSet.getString("RSOS001"),
					resultSet.getString("MUNIC001"),
					resultSet.getString("DOMIC001"),
					resultSet.getString("CPOSC001"),
					resultSet.getString("LOCAL001"),
					resultSet.getString("CCIF001"));

			if (UtilDAO.hasColumn(resultSet, "CNAE001")) {
				centro.setCnae001(resultSet.getString("CNAE001"));
			}
			if (UtilDAO.hasColumn(resultSet, "EMAIL001")) {
				centro.setEmail001(resultSet.getString("EMAIL001"));
			}
			Provincia provincia = new Provincia();
			provincia.setDescripcion(resultSet.getString("PROVINCIA"));
			centro.setProvincia(provincia);
			Municipio municipio = new Municipio();
			municipio.setDescripcion(resultSet.getString("MUNICIPIO"));
			centro.setMunicipio(municipio);
			return centro;
		}
	};

	private RowMapper<Centroj73> rwMapInfoFicha = new RowMapper<Centroj73>() {
		public Centroj73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Centroj73 centro = new Centroj73(resultSet.getInt("CODEMP001"),
					resultSet.getInt("CCEN001"), resultSet.getInt("NCEN001"),
					resultSet.getInt("PROVC001"),
					resultSet.getString("PROVINCIA"),
					resultSet.getString("RSOC001"),
					resultSet.getString("RSOS001"),
					resultSet.getString("MUNIC001"),
					resultSet.getString("DOMIC001"),
					resultSet.getString("CPOSC001"),
					resultSet.getString("LOCAL001"),
					resultSet.getString("CCIF001"),
					resultSet.getString("MUNICIPIO"),
					resultSet.getString("DESC_004"),
					resultSet.getString("DESC_003"),
					resultSet.getInt("NTRA_001"));

			if (UtilDAO.hasColumn(resultSet, "CNAE001")) {
				centro.setCnae001(resultSet.getString("CNAE001"));
			}
			Provincia provincia = new Provincia();
			provincia.setDescripcion(resultSet.getString("PROVINCIA"));
			centro.setProvincia(provincia);
			Municipio municipio = new Municipio();
			municipio.setDescripcion(resultSet.getString("MUNICIPIO"));
			centro.setMunicipio(municipio);
			return centro;
		}
	};

	private RowMapper<Centroj73> rwMapPK = new RowMapper<Centroj73>() {
		public Centroj73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Centroj73(resultSet.getInt("CODEMP001"));
		}
	};

	// private RowMapper<Centroj73> rwMapCentrosDatos = new
	// RowMapper<Centroj73>() {
	// public Centroj73 mapRow(ResultSet resultSet, int rowNum)
	// throws SQLException {
	// Centroj73 centroj73 = new Centroj73();
	//
	// centroj73.setNcen001(resultSet.getInt("NCEN001"));
	// centroj73.setCcen001(resultSet.getInt("CCEN001"));
	// centroj73.setCcif001(resultSet.getString("CCIF001"));
	// centroj73.setRsoc001(resultSet.getString("RSOC001"));
	// centroj73.setProvc001(resultSet.getInt("NOMPROVINC001"));
	// centroj73.setMunic001(resultSet.getString("NOMMUNICIP001"));
	// centroj73.setDomic001(resultSet.getString("DOMIC001"));
	//
	// return centroj73;
	// }
	// };

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 add(Centroj73 centroj73) {
		String query = "INSERT INTO J7301S00 (CODEMP_001, CCEN_001, PROVC_001, RSOC_001, RSOS_001, MUNIC_001, DOMIC_001, CPOSC_001, LOCAL_001, CCIF_001) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, centroj73.getCodemp001(),
				centroj73.getCcen001(), centroj73.getProvc001(),
				centroj73.getRsoc001(), centroj73.getRsos001(),
				centroj73.getMunic001(), centroj73.getDomic001(),
				centroj73.getCposc001(), centroj73.getLocal001(),
				centroj73.getCcif001());
		return centroj73;
	}

	/**
	 * Inserts a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 idUser String Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param idUser
	 *            the id user
	 * @return the centroj 73
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public Centroj73 addCentroJ73(Centroj73 centroj73, String idUser)
			throws AB04BException {
		try {

			String tabla = "J7301S00";
			// tabla pruebas
			// String tabla = "VCENTROJ73B";
			// tabla pruebas

			String query = "INSERT INTO " + tabla
					+ " (TCIF_001, CCIF_001, RSOC_001, RSOS_001, "
					+ "DOMIC_001, CPOSC_001, PROVC_001, MUNIC_001, LOCAL_001, TLF_001, FAX_001, EMAIL_001, COMER_001, "
					+ "DOMIF_001, PROVF_001, MUNIF_001, CPOSF_001, CNAE_001, DIVI_001, GRUP_001, CLAS_001, "
					+ "SECC_001, REGI_001, NTRA_001, BAJA_001, FBAJA_001, FACTU_001, OBSER_001, USUA_001, "
					+ "RSOC_007, RSOS_007, CNAE_007, SECC_007, USUA_007, USUALTA_001,INDTIPOCENTRO_001) "
					+ " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

			centroj73.setRsos001(
					Utilities.getInstance().quitarCaracteresEspecialesEspacios(
							centroj73.getRsoc001().toUpperCase()));

			if (centroj73.getCnae001().length() == ConstantesNum.NUM_2) {
				centroj73.setDivi001(centroj73.getCnae001().substring(0,
						ConstantesNum.NUM_2));
				centroj73.setGrupo001(" ");
				centroj73.setClas001(" ");

			} else if (centroj73.getCnae001().length() == ConstantesNum.NUM_3) {
				centroj73.setDivi001(centroj73.getCnae001().substring(0,
						ConstantesNum.NUM_2));
				centroj73.setGrupo001(centroj73.getCnae001()
						.substring(ConstantesNum.NUM_2, ConstantesNum.NUM_3));
				centroj73.setClas001(" ");
			} else if (centroj73.getCnae001().length() == ConstantesNum.NUM_4) {
				centroj73.setDivi001(centroj73.getCnae001().substring(0,
						ConstantesNum.NUM_2));
				centroj73.setGrupo001(centroj73.getCnae001()
						.substring(ConstantesNum.NUM_2, ConstantesNum.NUM_3));
				centroj73.setClas001(centroj73.getCnae001()
						.substring(ConstantesNum.NUM_3, ConstantesNum.NUM_4));
			}
			this.jdbcTemplate.update(query, centroj73.getTcif001(),
					centroj73.getCcif001().toUpperCase(),
					centroj73.getRsoc001().toUpperCase(),
					centroj73.getRsos001(), centroj73.getDomic001() != null
							? centroj73.getDomic001().toUpperCase()
							: centroj73.getDomic001(),
					centroj73.getCposc001(), centroj73.getProvc001(),
					centroj73.getCodMunic001(),
					centroj73.getLocal001() != null
							? centroj73.getLocal001().toUpperCase()
							: centroj73.getLocal001(),
					centroj73.getTlf001(), centroj73.getFax001(),
					centroj73.getEmail001(),
					centroj73.getComer001() != null
							? centroj73.getComer001().toUpperCase()
							: centroj73.getComer001(),
					centroj73.getDomif001() != null
							? centroj73.getDomif001().toUpperCase()
							: centroj73.getDomif001(),
					centroj73.getCodprof001(), centroj73.getCodmunif001(),
					centroj73.getCposf001(), centroj73.getCnae001(),
					centroj73.getDivi001(), centroj73.getGrupo001(),
					centroj73.getClas001(), centroj73.getSecc001(),
					centroj73.getRegi001(), centroj73.getNtra001(),
					centroj73.getBaja001(), centroj73.getFbaja001(),
					Utilities.getInstance().fncObtenerFechaHoy(),
					centroj73.getObser001() != null
							? centroj73.getObser001().toUpperCase()
							: centroj73.getObser001(),
					idUser, centroj73.getRsoc001().toUpperCase(),
					centroj73.getRsos001().toUpperCase(),
					centroj73.getCnae001(), centroj73.getSecc001(), idUser,
					idUser, Constantes.INDTIPCENTRO_J73);
			return centroj73;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Updates a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 update(Centroj73 centroj73) {
		String query = "UPDATE J7301S00 SET CCEN_001=?, PROVC_001=?, RSOC_001=?, RSOS_001=?, MUNIC_001=?, DOMIC_001=?, CPOSC_001=?, LOCAL_001=?, CCIF_001=? WHERE CODEMP_001=?";
		this.jdbcTemplate.update(query, centroj73.getCcen001(),
				centroj73.getProvc001(), centroj73.getRsoc001(),
				centroj73.getRsos001(), centroj73.getMunic001(),
				centroj73.getDomic001(), centroj73.getCposc001(),
				centroj73.getLocal001(), centroj73.getCcif001(),
				centroj73.getCodemp001());
		return centroj73;
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(readOnly = true)
	public Centroj73 find(Centroj73 centroj73) {
		String query = "SELECT t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, t1.PROVC_001 PROVC001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.MUNIC_001 MUNIC001, t1.DOMIC_001 DOMIC001, t1.CPOSC_001 CPOSC001, t1.LOCAL_001 LOCAL001, t1.CCIF_001 CCIF001 FROM J7301S00 t1  WHERE t1.CODEMP_001 = ?  ";

		List<Centroj73> centroj73List = this.jdbcTemplate.query(query,
				this.rwMap, centroj73.getCodemp001());
		return (Centroj73) DataAccessUtils.uniqueResult(centroj73List);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(readOnly = true)
	public Centroj73 findConsultaCentro(Centroj73 centroj73) {
		String query = " SELECT t1.TCIF_001 TCIF001, t1.CCIF_001 CCIF001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.DOMIC_001 DOMIC_001, t1.CPOSC_001 CPOSC001, t1.PROVC_001 PROVC001, t1.MUNIC_001 MUNIC001, "
				+ " t1.LOCAL_001 LOCAL001, t1.TLF_001 TLF001, t1.FAX_001 FAX001, t1.EMAIL_001 EMAIL001, t1.COMER_001 COMER001, t1.DOMIF_001 DOMIF001, t1.PROVF_001 PROVF001, t1.MUNIF_001 MUNIF001, t1.CPOSF_001 CPOSF001, trim(t1.CNAE_001) CNAE001,  "
				+ "t1.DIVI_001 DIVI001, t1.GRUP_001 GRUP001, t1.CLAS_001 CLAS001, t1.SECC_001 SECC001, t1.REGI_001 REGI001, t1.NTRA_001 NTRA001, t1.BAJA_001 BAJA001, t1.FBAJA_001 FBAJA001, t1.FACTU_001 FACTU001, "
				+ "t1.OBSER_001 OBSER001, t1.USUA_001 USUA001, t1.RSOC_007 RSOC007, t1.RSOS_007 RSOS007, trim(t1.CNAE_007) CNAE007, t1.SECC_007 SECC007, t1.USUA_007 USUA007, t1.USUALTA_001 USUALTA001,"
				+ " t1.INDTIPOCENTRO_001 INDTIPOCENTRO001,t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.CCEN_001 CCEN001, '' PROVINCIA, '' MUNICIPIO  FROM J7301S00 t1  WHERE t1.CCIF_001 = ?  AND t1.CCEN_001 = ?";

		List<Centroj73> centroj73List = this.jdbcTemplate.query(query,
				this.rwMapConsulta, centroj73.getCcif001(),
				centroj73.getCcen001());
		return (Centroj73) DataAccessUtils.uniqueResult(centroj73List);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(readOnly = true)
	public Centroj73 findConsultaNuevoCentro(Centroj73 centroj73) {
		String query = " SELECT t1.TCIF_001 TCIF001, t1.CCIF_001 CCIF001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.DOMIC_001 DOMIC_001, t1.CPOSC_001 CPOSC001, t1.PROVC_001 PROVC001, t1.MUNIC_001 MUNIC001, "
				+ " t1.LOCAL_001 LOCAL001, t1.TLF_001 TLF001, t1.FAX_001 FAX001, t1.EMAIL_001 EMAIL001, t1.COMER_001 COMER001, t1.DOMIF_001 DOMIF001, t1.PROVF_001 PROVF001, t1.MUNIF_001 MUNIF001, t1.CPOSF_001 CPOSF001, trim(t1.CNAE_001) CNAE001,  "
				+ "t1.DIVI_001 DIVI001, t1.GRUP_001 GRUP001, t1.CLAS_001 CLAS001, t1.SECC_001 SECC001, t1.REGI_001 REGI001, t1.NTRA_001 NTRA001, t1.BAJA_001 BAJA001, t1.FBAJA_001 FBAJA001, t1.FACTU_001 FACTU001, "
				+ "t1.OBSER_001 OBSER001, t1.USUA_001 USUA001, t1.RSOC_007 RSOC007, t1.RSOS_007 RSOS007, trim(t1.CNAE_007) CNAE007, t1.SECC_007 SECC007, t1.USUA_007 USUA007, t1.USUALTA_001 USUALTA001,"
				+ " t1.INDTIPOCENTRO_001 INDTIPOCENTRO001,t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, '' PROVINCIA, '' MUNICIPIO  FROM J7301S00 t1  WHERE t1.CCIF_001 = ?  AND t1.NCEN_001 = ?";

		List<Centroj73> centroj73List = this.jdbcTemplate.query(query,
				this.rwMapConsulta, centroj73.getCcif001(),
				centroj73.getNcen001());
		return (Centroj73) DataAccessUtils.uniqueResult(centroj73List);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(readOnly = true)
	public Centroj73 findByCif(Centroj73 centroj73) {
		String query = "SELECT t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, t1.PROVC_001 PROVC001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.MUNIC_001 MUNIC001, t1.DOMIC_001 DOMIC001, t1.CPOSC_001 CPOSC001, t1.LOCAL_001 LOCAL001, t1.CCIF_001 CCIF001, PROVINCIA.DS_O PROVINCIA, MUNICIPIO.DS_O MUNICIPIO FROM J7301S00 t1 LEFT OUTER JOIN PROVINCIA ON (ID = t1.PROVC_001) LEFT OUTER JOIN MUNICIPIO ON (MUNICIPIO.PROVINCIA_ID = t1.PROVC_001 AND MUNICIPIO.ID = t1.MUNIC_001)  WHERE t1.CCIF_001 = ?  ";

		List<Centroj73> centroj73List = this.jdbcTemplate.query(query,
				this.rwMap, centroj73.getCcif001());
		return (Centroj73) DataAccessUtils.uniqueResult(centroj73List);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Centroj73> findByCifTHRSoc(Centroj73 centroj73) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, t1.PROVC_001 PROVC001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.MUNIC_001 MUNIC001, t1.DOMIC_001 DOMIC001, t1.CPOSC_001 CPOSC001, t1.LOCAL_001 LOCAL001, t1.CCIF_001 CCIF001, PROVINCIA.DS_O PROVINCIA, MUNICIPIO.DS_O MUNICIPIO FROM J7301S00 t1 LEFT OUTER JOIN PROVINCIA ON (ID = t1.PROVC_001) LEFT OUTER JOIN MUNICIPIO ON (MUNICIPIO.PROVINCIA_ID = t1.PROVC_001 AND MUNICIPIO.ID = t1.MUNIC_001)   ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(centroj73);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), this.rwMap,
				params.toArray());
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(readOnly = true)
	public Centroj73 findByExpdte(Centroj73 centroj73) {
		String query = "SELECT t1.CCIF_001 CCIF001, t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, trim(t1.CNAE_001) CNAE001, t1.PROVC_001 PROVC001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.MUNIC_001 MUNIC001, t1.DOMIC_001 DOMIC001, t1.CPOSC_001 CPOSC001, t1.LOCAL_001 LOCAL001, t1.CCIF_001 CCIF001, PROVINCIA.DS_O PROVINCIA, MUNICIPIO.DS_O MUNICIPIO FROM J7301S00 t1 LEFT OUTER JOIN PROVINCIA ON (ID = t1.PROVC_001) LEFT OUTER JOIN MUNICIPIO ON (MUNICIPIO.PROVINCIA_ID = t1.PROVC_001 AND MUNICIPIO.ID = t1.MUNIC_001)  WHERE t1.CCEN_001 = (SELECT CODCENTROJ73_001 FROM L61B.L61B01T00 WHERE CODEXPEDIENTE_001 =  ?)  ";

		List<Centroj73> centroj73List = this.jdbcTemplate.query(query,
				this.rwMapInfo, centroj73.getCodexpediente());
		return (Centroj73) DataAccessUtils.uniqueResult(centroj73List);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(readOnly = true)
	public Centroj73 findByExpdteFicha(Centroj73 centroj73) {
		String query = "SELECT t1.CCIF_001 CCIF001,  t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001,"
				+ " trim(t1.CNAE_001) CNAE001, t1.PROVC_001 PROVC001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.MUNIC_001 MUNIC001,"
				+ " t1.DOMIC_001 DOMIC001,  t1.CPOSC_001 CPOSC001,  t1.LOCAL_001 LOCAL001,  t1.CCIF_001 CCIF001,  PROVINCIA.DS_O PROVINCIA,"
				+ " MUNICIPIO.DS_O MUNICIPIO,  J7304S00.DESC_004,  VRAMAS.DESC_003,  t1.NTRA_001 FROM J7301S00 t1 LEFT OUTER JOIN PROVINCIA"
				+ " ON (PROVINCIA.ID = t1.PROVC_001) LEFT OUTER JOIN MUNICIPIO ON MUNICIPIO.PROVINCIA_ID = t1.PROVC_001"
				+ " AND MUNICIPIO.ID = t1.MUNIC_001 LEFT JOIN J7304S00 ON t1.SECC_001 = J7304S00.SECC_004 LEFT JOIN VRAMAS"
				+ " ON t1.CNAE_001 = VRAMAS.CNAE_003 AND t1.SECC_001   = VRAMAS.SECC_003 WHERE t1.CCEN_001 = "
				+ "(SELECT L61B01T00.CODCENTROJ73_001 FROM L61B01T00 WHERE L61B01T00.CODEXPEDIENTE_001 = ?)";

		List<Centroj73> centroj73List = this.jdbcTemplate.query(query,
				this.rwMapInfoFicha, centroj73.getCodexpediente());
		return (Centroj73) DataAccessUtils.uniqueResult(centroj73List);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(readOnly = true)
	public Centroj73 findByExpdteHuelga(Centroj73 centroj73) {
		String query = "SELECT t1.CCIF_001 CCIF001, t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, trim(t1.CNAE_001) CNAE001, t1.EMAIL_001 EMAIL001, t1.PROVC_001 PROVC001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.MUNIC_001 MUNIC001, t1.DOMIC_001 DOMIC001, t1.CPOSC_001 CPOSC001, t1.LOCAL_001 LOCAL001, t1.CCIF_001 CCIF001, PROVINCIA.DS_O PROVINCIA, MUNICIPIO.DS_O MUNICIPIO FROM J7301S00 t1 LEFT OUTER JOIN PROVINCIA ON (ID = t1.PROVC_001) LEFT OUTER JOIN MUNICIPIO ON (MUNICIPIO.PROVINCIA_ID = t1.PROVC_001 AND MUNICIPIO.ID = t1.MUNIC_001)  WHERE t1.CCEN_001 = (SELECT CODCENTROJ73_033 FROM L61B.L61B33T00 WHERE CODEXPEDIENTE_033 =  ?)  ";

		List<Centroj73> centroj73List = this.jdbcTemplate.query(query,
				this.rwMapInfo, centroj73.getCodexpediente());
		return (Centroj73) DataAccessUtils.uniqueResult(centroj73List);
	}

	/**
	 * Encuentra el centro que acabamos de dar de alta.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(readOnly = true)
	public Centroj73 findCentroAlta(Centroj73 centroj73) {

		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder(
				" SELECT t1.TCIF_001 TCIF001, t1.CCIF_001 CCIF001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.DOMIC_001 DOMIC_001, t1.CPOSC_001 CPOSC001, t1.PROVC_001 PROVC001, t1.MUNIC_001 MUNIC001, ");
		query.append(
				"t1.LOCAL_001 LOCAL001, t1.TLF_001 TLF001, t1.FAX_001 FAX001, t1.EMAIL_001 EMAIL001, t1.COMER_001 COMER001, t1.DOMIF_001 DOMIF001, t1.PROVF_001 PROVF001, t1.MUNIF_001 MUNIF001, t1.CPOSF_001 CPOSF001, trim(t1.CNAE_001) CNAE001,  ");
		query.append(
				"t1.DIVI_001 DIVI001, t1.GRUP_001 GRUP001, t1.CLAS_001 CLAS001, t1.SECC_001 SECC001, t1.REGI_001 REGI001, t1.NTRA_001 NTRA001, t1.BAJA_001 BAJA001, t1.FBAJA_001 FBAJA001, t1.FACTU_001 FACTU001, ");
		query.append(
				"t1.OBSER_001 OBSER001, t1.USUA_001 USUA001, t1.RSOC_007 RSOC007, t1.RSOS_007 RSOS007, trim(t1.CNAE_007) CNAE007, t1.SECC_007 SECC007, t1.USUA_007 USUA007, t1.USUALTA_001 USUALTA001,");
		query.append(
				" t1.INDTIPOCENTRO_001 INDTIPOCENTRO001,t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, '' PROVINCIA, '' MUNICIPIO  FROM J7301S00 t1 WHERE ");

		query.append(" UPPER(t1.CCIF_001) = ? ");
		params.add(centroj73.getCcif001().toUpperCase());

		query.append(
				" AND t1.NCEN_001 =(SELECT max(NCEN_001) FROM J7301S00 WHERE ");

		query.append(" UPPER(CCIF_001) = ? )");
		params.add(centroj73.getCcif001().toUpperCase());

		List<Centroj73> centroj73List = null;
		centroj73List = this.jdbcTemplate.query(query.toString(),
				this.rwMapConsulta, params.toArray());

		return (Centroj73) DataAccessUtils.uniqueResult(centroj73List);

	}

	/**
	 * Removes a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 */
	public void remove(Centroj73 centroj73) {
		String query = "DELETE FROM J7301S00 WHERE CODEMP_001=?";
		this.jdbcTemplate.update(query, centroj73.getCodemp001());
	}

	/**
	 * Finds a list of rows in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 jqGridRequestDto JQGridRequestDto List<Centroj73>
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Centroj73> findAll(Centroj73 centroj73,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODEMP_001 CODEMP001,t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, t1.PROVC_001 PROVC001,t1.RSOC_001 RSOC001,t1.RSOS_001 RSOS001,t1.MUNIC_001 MUNIC001,t1.DOMIC_001 DOMIC001,t1.CPOSC_001 CPOSC001,t1.LOCAL_001 LOCAL001,t1.CCIF_001 CCIF001 ");
		query.append("FROM J7301S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(centroj73);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Centroj73>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Centroj73 table using like.
	 * 
	 * centroj73 Centroj73 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Centroj73>
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Centroj73> findAllLike(Centroj73 centroj73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.TCIF_001 TCIF001, t1.CCIF_001 CCIF001, t1.RSOC_001 RSOC001, t1.RSOS_001 RSOS001, t1.DOMIC_001 DOMIC_001, t1.CPOSC_001 CPOSC001, t1.PROVC_001 PROVC001, t1.MUNIC_001 MUNIC001, "
						+ " t1.LOCAL_001 LOCAL001, t1.TLF_001 TLF001, t1.FAX_001 FAX001, t1.EMAIL_001 EMAIL001, t1.COMER_001 COMER001, t1.DOMIF_001 DOMIF001, t1.PROVF_001 PROVF001, t1.MUNIF_001 MUNIF001, t1.CPOSF_001 CPOSF001, trim(t1.CNAE_001) CNAE001,  "
						+ "t1.DIVI_001 DIVI001, t1.GRUP_001 GRUP001, t1.CLAS_001 CLAS001, t1.SECC_001 SECC001, t1.REGI_001 REGI001, t1.NTRA_001 NTRA001, t1.BAJA_001 BAJA001, t1.FBAJA_001 FBAJA001, t1.FACTU_001 FACTU001, "
						+ "t1.OBSER_001 OBSER001, t1.USUA_001 USUA001, t1.RSOC_007 RSOC007, t1.RSOS_007 RSOS007, trim(t1.CNAE_007) CNAE007, t1.SECC_007 SECC007, t1.USUA_007 USUA007, t1.USUALTA_001 USUALTA001, t1.NTRAH_001 NTRAH001, t1.NTRAM_001 NTRAM001,"
						+ " t1.INDTIPOCENTRO_001 INDTIPOCENTRO001,t1.CODEMP_001 CODEMP001, t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001, PROVINCIA.DS_O PROVINCIA, MUNICIPIO.DS_O MUNICIPIO FROM J7301S00 t1 LEFT OUTER JOIN PROVINCIA ON (t1.PROVC_001 = TO_NUMBER(PROVINCIA.ID)) LEFT OUTER JOIN MUNICIPIO ON (t1.PROVC_001 = TO_NUMBER(MUNICIPIO.PROVINCIA_ID) AND t1.MUNIC_001 = TO_NUMBER(MUNICIPIO.ID)) ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(centroj73, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Centroj73>) this.jdbcTemplate.query(query.toString(),
				this.rwMapConsulta, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Long
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Centroj73 centroj73) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM J7301S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(centroj73);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Centroj73 table using like.
	 * 
	 * centroj73 Centroj73 startsWith Boolean Long
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Centroj73 centroj73, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM J7301S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(centroj73, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Centroj73 selected for rup_table.
	 * 
	 * centroj73 Centroj73 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Centroj73>>
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Centroj73>> reorderSelection(Centroj73 centroj73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODEMP_001 CODEMP001,t1.CCEN_001 CCEN001, t1.NCEN_001 NCEN001,t1.PROVC_001 PROVC001,t1.RSOC_001 RSOC001,t1.RSOS_001 RSOS001,t1.MUNIC_001 MUNIC001,t1.DOMIC_001 DOMIC001,t1.CPOSC_001 CPOSC001,t1.LOCAL_001 LOCAL001,t1.CCIF_001 CCIF001 ");
		// FROM
		query.append("FROM J7301S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(centroj73, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Centroj73.class, filterParamList,
				"CODEMP_001");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Centroj73>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Centroj73 entity.
	 * 
	 * centroj73 Centroj73 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Centroj73 centroj73) {

		StringBuilder where = new StringBuilder(
				Centroj73DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (centroj73 != null && centroj73.getCodemp001() != null) {
			where.append(" AND t1.CODEMP_001 = ?");
			params.add(centroj73.getCodemp001());
		}
		if (centroj73 != null && centroj73.getCcen001() != null) {
			where.append(" AND t1.CCEN_001 = ?");
			params.add(centroj73.getCcen001());
		}
		if (centroj73 != null && centroj73.getNcen001() != null) {
			where.append(" AND t1.NCEN_001 = ?");
			params.add(centroj73.getNcen001());
		}
		if (centroj73 != null && centroj73.getProvc001() != null) {
			where.append(" AND t1.PROVC_001 = ?");
			params.add(centroj73.getProvc001());
		}
		if (centroj73 != null && centroj73.getRsoc001() != null) {
			where.append(" AND t1.RSOC_001 = ?");
			params.add(centroj73.getRsoc001());
		}
		if (centroj73 != null && centroj73.getRsos001() != null) {
			where.append(" AND t1.RSOS_001 = ?");
			params.add(centroj73.getRsos001());
		}
		if (centroj73 != null && centroj73.getMunic001() != null) {
			where.append(" AND t1.MUNIC_001 = ?");
			params.add(centroj73.getMunic001());
		}
		if (centroj73 != null && centroj73.getDomic001() != null) {
			where.append(" AND t1.DOMIC_001 = ?");
			params.add(centroj73.getDomic001());
		}
		if (centroj73 != null && centroj73.getCposc001() != null) {
			where.append(" AND t1.CPOSC_001 = ?");
			params.add(centroj73.getCposc001());
		}
		if (centroj73 != null && centroj73.getLocal001() != null) {
			where.append(" AND t1.LOCAL_001 = ?");
			params.add(centroj73.getLocal001());
		}
		if (centroj73 != null && centroj73.getCcif001() != null) {
			where.append(" AND t1.CCIF_001 = ?");
			params.add(centroj73.getCcif001());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Centroj73 entity.
	 * 
	 * centroj73 Centroj73 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Centroj73 centroj73,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Centroj73DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (centroj73 != null) {

			if (centroj73.getCodemp001() != null) {
				where.append(" AND t1.CODEMP_001 = ?");
				params.add(centroj73.getCodemp001());
			}
			if (centroj73.getCcen001() != null) {
				where.append(" AND t1.CCEN_001 = ?");
				params.add(centroj73.getCcen001());
			}
			if (centroj73.getProvc001() != null) {
				where.append(" AND t1.PROVC_001 = ?");
				params.add(centroj73.getProvc001());
			} else {
				where.append("AND t1.PROVC_001 IN (?, ?, ?)");
				params.add(Constantes.TH_ALAVA);
				params.add(Constantes.TH_GIPUZKOA);
				params.add(Constantes.TH_BIZKAIA);

			}
			if (centroj73.getRsoc001() != null) {
				where.append(" AND UPPER(t1.RSOC_001) like ? ");
				if (startsWith) {
					params.add(centroj73.getRsoc001().toUpperCase() + "%");
				} else {
					params.add(
							"%" + centroj73.getRsoc001().toUpperCase() + "%");
				}
				where.append(" AND t1.RSOC_001 IS NOT NULL");
			}
			if (centroj73.getRsos001() != null) {
				where.append(" AND UPPER(t1.RSOS_001) like ? ");
				if (startsWith) {
					params.add(centroj73.getRsos001().toUpperCase() + "%");
				} else {
					params.add(
							"%" + centroj73.getRsos001().toUpperCase() + "%");
				}
				where.append(" AND t1.RSOS_001 IS NOT NULL");
			}
			if (centroj73.getMunic001() != null) {
				where.append(" AND t1.MUNIC_001 = ?");
				params.add(centroj73.getMunic001());
			}
			if (centroj73.getDomic001() != null) {
				where.append(" AND UPPER(t1.DOMIC_001) like ? ");
				if (startsWith) {
					params.add(centroj73.getDomic001().toUpperCase() + "%");
				} else {
					params.add(
							"%" + centroj73.getDomic001().toUpperCase() + "%");
				}
				where.append(" AND t1.DOMIC_001 IS NOT NULL");
			}
			if (centroj73.getCposc001() != null) {
				where.append(" AND t1.CPOSC_001 = ?");
				params.add(centroj73.getCposc001());
			}
			if (centroj73.getLocal001() != null) {
				where.append(" AND UPPER(t1.LOCAL_001) like ? ");
				if (startsWith) {
					params.add(centroj73.getLocal001().toUpperCase() + "%");
				} else {
					params.add(
							"%" + centroj73.getLocal001().toUpperCase() + "%");
				}
				where.append(" AND t1.LOCAL_001 IS NOT NULL");
			}
			if (centroj73.getCcif001() != null) {
				where.append(" AND UPPER(t1.CCIF_001) like ? ");
				if (startsWith) {
					params.add(centroj73.getCcif001().toUpperCase() + "%");
				} else {
					params.add(
							"%" + centroj73.getCcif001().toUpperCase() + "%");
				}
				where.append(" AND t1.CCIF_001 IS NOT NULL");
			}
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
